#include <iostream>
#include <vector>

using namespace std;

class ModArr
{
public:
    vector<int> arr;
    ModArr(vector<int> init)
    {
        for(int x : init)
            arr.push_back(x);
    }

    int operator[](int n)
    {
        return arr[n%arr.size()];
    }

    void PostElement(int n, int val)
    {
        arr[n] = val;
    }
};

bool DaLiJePeriod(ModArr& a, int d, int p)
{
    for(int i = p; i < p+d; ++i)
        if(a[i] != a[i+d]) return false;

    return true;
}

bool MogucPeriod(ModArr& a, int n, int d)
{
    for(int i = 0; i < n; ++i)
        if(!DaLiJePeriod(a, d, i)) return false;
    return true;
}

int MinPeriod(ModArr& a, int n)
{
    for(int i = 1; i <= n; ++i)
        if(MogucPeriod(a, n, i)) return i;


}

void UpdateB(ModArr& a, ModArr& b, int i)
{
    int res1 = a[i-1] ^ a[i];
    int res2 = a[i] ^ a[i+1];
    b.PostElement(i-1,res1);
    b.PostElement(i,res2);
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);


    int n, q;
    cin >> n >> q;

    vector<int> arr (n);
    for(int i = 0; i < n; ++i)
    {
        cin >> arr[i];
    }


    ModArr arra(arr);
    vector<int> b (n);
    for(int i = 0; i < n-1; ++i)
        b[i] = arr[i] ^ arr[i+1];
    b[n-1] = arr[n-1] ^ arr[0];

    ModArr arrb(b);
    cout << MinPeriod(arrb, n) <<"\n";

    int p, v;
    for(int i = 0; i < q; ++i)
    {
        cin >> p>> v;
        --p;
        arra.PostElement(p, v);
        UpdateB(arra, arrb, p);

        cout << MinPeriod(arrb, n) <<"\n";

    }
}